// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.CustomerGroupsFactory', {

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_analytics/main',

    constructor: function (config) {
        if (!config.store) {
            throw new Error('Needs a store');
        }
        this.config = Object.create(null, {
            store: {
                value: config.store,
                enumerable: true,
            },
        });

        this.callParent(arguments);
    },

    getToolbarComponentValueRetriever: function () {
        return function (toolbar) {
            var selectedCustomerGroups = toolbar.child('[name=viison_pickware_erp_analytics_customer_groups_selection]')
                .getValue();
            if (selectedCustomerGroups === undefined || selectedCustomerGroups === null) {
                return selectedCustomerGroups;
            }

            return selectedCustomerGroups.join(',');
        };
    },

    getToolbarFilterConfig: function () {
        return {
            componentConfig: Ext.apply(
                {
                    xtype: 'combobox',
                    iconCls: 'sprite-gear',
                    name: 'viison_pickware_erp_analytics_customer_groups_selection',
                    queryMode: 'remote',
                    fieldLabel: this.getViisonSnippet('toolbar/customer_groups'),
                    store: this.customerGroupsStore,
                    multiSelect: true,
                    displayField: 'name',
                    valueField: 'id',
                },
                this.config
            ),
        };
    },

});
