// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultToDateFactory', {

    getToolbarComponentValueRetriever: function () {
        return function (toolbar) {
            var dateText = toolbar.child('[name=to_date]').getValue();

            return Ext.Date.format(dateText, 'Y-m-d');
        };
    },

    getToolbarFilterConfig: function () {
        return {
            componentConfig: {
                name: 'to_date',
                isDefault: true,
            },
        };
    },

});
