// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.component.MigrationLog', {
    extend: 'Ext.form.field.TextArea',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_migration/main',

    readOnly: true,
    cls: 'is--viison-common--textarea viison_common_migration-component-migration_log',
    style: {
        fontFamily: 'Arial, Verdana, sans-serif',
    },

    migrationExecutionResult: null,

    initComponent: function () {
        this.callParent(arguments);

        this.setValueFromMigrationExecutionResult(this.migrationExecutionResult);
    },

    /**
     * Fills the content with the log for a MigrationExecutionResult
     *
     * @param {Shopware.apps.ViisonCommonMigration.model.MigrationExecutionResult} migrationExecutionResult
     */
    setValueFromMigrationExecutionResult: function (migrationExecutionResult) {
        if (!migrationExecutionResult) {
            this.setValue('');
        }

        var log = '';
        log += migrationExecutionResult.getMessages().join('\n\n');
        log += '\n\n' + this.getViisonSnippet('migrationLog/clearedCaches') + '\n';
        log += migrationExecutionResult.getInvalidatedCaches().join(', ');

        this.setValue(log);
    },

    /**
     * Extends the content with the log for a pluginDisablingResult
     *
     * @param {object} pluginDisablingResultData
     */
    appendPluginDisablingResultData: function (pluginDisablingResultData) {
        var log = this.getValue();
        log += '\n\n' + this.getViisonSnippet('migrationLog/disabledPlugins') + '\n';
        log += pluginDisablingResultData.messages.join('\n');
        log += '\n\n' + this.getViisonSnippet('migrationLog/clearedCaches') + '\n';
        log += pluginDisablingResultData.invalidatedCaches.join(', ');
        this.setValue(log);
    },
});
