### Configuration logic

> The implementation of [SHIPMENTLOGIC.md](SHIPMENTLOGIC.md) needs to be done first.

**Plugin Info**

* Inside the `PluginInfo.php` file override the `getConfigurationModelName()` method

> The following method is not declared as Abstract inside Shipping Common because of the Backwards compatibility of Shipping Common.

```php
    ...
       /**
        * @Override from ShippingCommon
       */
       public function getConfigurationModelName()
       {
           return 'Shopware\CustomModels\ViisonPROVIDER_NAME\Configuration\Configuration';
       }
    ...
```

**Entities**

* Add `ViisonProviderName\Configuration` folder to the `Models` directory.
* Add `Configuration.php` & `Repository.php` files inside the Configuration directory.
* Define the namespaces to follow this schema:
 `namespace Shopware\CustomModels\ViisonProviderName\Configuration;`
* Include the respective file namespaces from Shipping Common (for `Configuration.php` the [Configuration class](Models/ViisonShippingCommon/Configuration/Configuration.php) from ShippingCommon and so on) also add the Doctrine namespaces to `Configuration.php`

```php
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
```
* Add the `@ORM\Table` and `@ORM\Entity` tags on the top of the class declaration s inside `Configuration.php`

```php
/**
 * Extends Configuration model from ShippingCommon
 *
 * @ORM\Entity(repositoryClass="Shopware\CustomModels\ViisonProviderName\Configuration\Repository")
 * @ORM\Table(name="s_core_shops_viison_PROVIDER_NAME")
 *
 */
class Configuration extends ViisonShippingCommonConfiguration {...}
```

> The @ORM\Table needs to point to the existing configuration table if the Shipping Provider has been already released.

* Add the `pdfSize` field (if not exist) inside the Shipping Provider's configuration table.

  > The pdfSize should have a default value inside the Table.

* Implement the Abstract methods.

  > The abstract methods for encryption should return null/array() if the Shipping Provider does not support this fields.

* Implement the Shipping Provider missing configuration fields and generate the getters/setters for it.

  > The fields should have the column names from the existing table if the Adapter has been already Released.

* Extend the [Repository class](Models/ViisonShippingCommon/Configuration/Repository.php) from Shipping Common in `Repository.php`.

**Communication**

* Implement the read of the PDF size from the configuration table `pdfSize` field (if not already implemented).
