<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes;

use Shopware\Plugins\ViisonShippingCommon\Classes\Communication\Communication;

// TODO extend Communication class after we are ready to change DHL to new Communication logic

abstract class DailyClosingGenerator
{
    abstract public function getDailyClosing($shopId, $fromDate, $toDate);

    /**
     * @param int|null $shopId The id of the subshop, for which the daily closing
     * should be generated or null if the daily closing should be created for all subshops.
     * @param null|string $fromDate The starting date for which the daily closing
     * should be generated or null if no restriction should be made for the starting date.
     * @param null|string $toDate The ending date for which the daily closing
     * should be generated or null if no restriction should be made for the ending date.
     * @return void|string
     */
    public function getDailyClosingForNewLabels($shopId, $fromDate = null, $toDate = null)
    {
    }
}
