<?php

namespace Shopware\Plugins\ViisonShippingCommon\Classes\Exceptions;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class CurrencyConverterException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        $this->snippetName = $snippetName;
        $this->snippetNamespace  = 'exceptions/currency_converter';
        $this->snippetArguments = $snippetArguments;

        parent::__construct(vsprintf($message, $snippetArguments));
    }

    /**
     * @param string $currency
     * @return self
     */
    public static function currencyFactorNotConfigured($currency)
    {
        return new self(
            'The currency factor is not configured for %s.',
            'currencyFactorNotConfigured',
            [$currency]
        );
    }
}
