<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes;

use Shopware\Plugins\ViisonCommon\Classes\AbstractSubscriberRegistrator;
use Shopware\Plugins\ViisonShippingCommon\Subscriber;

/**
 * Use this registrator just befor registering your subscribers in the plugin bootstrap:
 *
 *  $viisonShippingCommonSubscriberRegistrator = new Shopware\Plugins\ViisonShippingCommon\Classes\SubscriberRegistrator($this);
 *  $viisonShippingCommonSubscriberRegistrator->registerSubscribers();
 */
class SubscriberRegistrator extends AbstractSubscriberRegistrator
{
    /**
     * @inheritdoc
     */
    protected function createSubscribers()
    {
        return array(
            new Subscriber\CompatibilityCheck($this->pluginBootstrap),
            new Subscriber\Services($this->pluginBootstrap),
            new Subscriber\SubApplicationRegistration($this->pluginBootstrap),
            new Subscriber\ViewLoading($this->pluginBootstrap),
            new Subscriber\CheckoutSubscriber($this->pluginBootstrap),
            new Subscriber\OrderAttributeSubscriber($this->pluginBootstrap),
        );
    }
}
