<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes\Types;

class LabelFile
{
    /**
     * @var string
     */
    private $pdf;

    /**
     * @var string
     */
    private $fileName;

    /**
     * @var string
     */
    private $trackingCode;

    public function __construct($pdf, $fileName, $trackingCode)
    {
        $this->pdf = $pdf;
        $this->fileName = $fileName;
        $this->trackingCode = $trackingCode;
    }

    /**
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * @return string
     */
    public function getFileName()
    {
        return $this->fileName;
    }

    /**
     * @return string
     */
    public function getTrackingCode()
    {
        return $this->trackingCode;
    }
}
