<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\Export;

use Shopware\Plugins\ViisonShippingCommon\Classes\PluginInfo;

/**
 * Is used as a bridge for the dispatch Export position service.
 */
class FakePluginInfo extends PluginInfo
{
    /**
     * @inheritdoc
     */
    public function getOrderTableName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getConfigTableName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getProductTableName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getProductMappingTableName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getFilePrefix()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getPluginDisplayName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getPluginName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getReturnLabelEmailTemplateName()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getTrackingURL()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getTrackingNumberDelimiter()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function getMaxLabels()
    {
        return null;
    }

    /**
     * @inheritdoc
     */
    public function pluginSupportsExportDocuments()
    {
        return true;
    }
}
