<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\Export;

class Position
{
    /**
     * @var string
     */
    protected $name = '';

    /**
     * @var int
     */
    protected $quantity = 0;

    /**
     * @var float
     */
    protected $netWeightInKg = 0.0;

    /**
     * @var float
     */
    protected $netPrice = 0.0;

    /**
     * @var string
     */
    protected $tariffNumber = '';

    /**
     * @var string
     */
    protected $countryIsoOfOrigin = '';

    /**
     * @var string
     */
    protected $articleOrderNumber = '';

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Position
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     * @return Position
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;

        return $this;
    }

    /**
     * @return float
     */
    public function getNetWeightInKg()
    {
        return $this->netWeightInKg;
    }

    /**
     * @param float $netWeightInKg
     * @return Position
     */
    public function setNetWeightInKg($netWeightInKg)
    {
        $this->netWeightInKg = $netWeightInKg;

        return $this;
    }

    /**
     * @return float
     */
    public function getNetPrice()
    {
        return $this->netPrice;
    }

    /**
     * @param float $netPrice
     * @return Position
     */
    public function setNetPrice($netPrice)
    {
        $this->netPrice = $netPrice;

        return $this;
    }

    /**
     * @return string
     */
    public function getTariffNumber()
    {
        return $this->tariffNumber;
    }

    /**
     * @param string $tariffNumber
     * @return Position
     */
    public function setTariffNumber($tariffNumber)
    {
        $this->tariffNumber = $tariffNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getCountryIsoOfOrigin()
    {
        return $this->countryIsoOfOrigin;
    }

    /**
     * @param string $countryIsoOfOrigin
     * @return Position
     */
    public function setCountryIsoOfOrigin($countryIsoOfOrigin)
    {
        $this->countryIsoOfOrigin = $countryIsoOfOrigin;

        return $this;
    }

    /**
     * @return string
     */
    public function getArticleOrderNumber()
    {
        return $this->articleOrderNumber;
    }

    /**
     * @param string $articleOrderNumber
     * @return Position
     */
    public function setArticleOrderNumber($articleOrderNumber)
    {
        $this->articleOrderNumber = $articleOrderNumber;

        return $this;
    }

    /**
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->quantity * $this->netPrice;
    }

    /**
     * @return float
     */
    public function getGrossWeight()
    {
        return $this->quantity * $this->netWeightInKg;
    }
}
