<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\ReturnLabelCreation;

use Shopware\Components\Model\ModelManager;
use Shopware\Plugins\ViisonShippingCommon\Classes\Communication\Communication;
use Shopware\Plugins\ViisonShippingCommon\Classes\PluginInfo;
use Shopware\Plugins\ViisonShippingCommon\Classes\ShippingLabelGenerator;
use Shopware\Plugins\ViisonShippingCommon\Components\OrderShipmentDataGeneratorService;
use Shopware\Plugins\ViisonShippingCommon\Util;

class ReturnLabelCreatorFactoryService
{
    /**
     * @var ModelManager
     */
    private $entityManager;

    /**
     * @var OrderShipmentDataGeneratorService
     */
    private $orderShipmentDataGeneratorService;

    /**
     * @param ModelManager $entityManager
     * @param OrderShipmentDataGeneratorService $orderShipmentDataGeneratorService
     */
    public function __construct($entityManager, OrderShipmentDataGeneratorService $orderShipmentDataGeneratorService)
    {
        $this->entityManager = $entityManager;
        $this->orderShipmentDataGeneratorService = $orderShipmentDataGeneratorService;
    }

    /**
     * @param PluginInfo $pluginInfo
     * @param Util $util
     * @param Communication|null $communication
     * @param ShippingLabelGenerator|null $shippingLabelGenerator
     * @return ReturnLabelCreator
     */
    public function createReturnLabelCreator(
        PluginInfo $pluginInfo,
        Util $util,
        Communication $communication = null,
        ShippingLabelGenerator $shippingLabelGenerator = null
    ) {
        if ($pluginInfo->getShipmentModelName() === null) {
            return new TableBasedReturnLabelCreator(
                $this->orderShipmentDataGeneratorService,
                $pluginInfo,
                $util,
                $shippingLabelGenerator
            );
        }

        return new ModelBasedReturnLabelCreator($this->entityManager, $pluginInfo, $communication);
    }
}
