<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\ReturnLabelCreation;

use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonShippingCommon\Classes\PluginInfo;
use Shopware\Plugins\ViisonShippingCommon\Classes\ShippingLabelGenerator;
use Shopware\Plugins\ViisonShippingCommon\Components\OrderShipmentDataGeneratorService;
use Shopware\Plugins\ViisonShippingCommon\Util;

class TableBasedReturnLabelCreator implements ReturnLabelCreator
{
    /**
     * @var OrderShipmentDataGeneratorService
     */
    private $orderShipmentDataGeneratorService;

    /**
     * @var PluginInfo
     */
    private $pluginInfo;

    /**
     * @var Util
     */
    private $util;

    /**
     * @var ShippingLabelGenerator
     */
    private $shippingLabelGenerator;

    /**
     * @param OrderShipmentDataGeneratorService $orderShipmentDataGeneratorService
     * @param PluginInfo $pluginInfo
     * @param Util $util
     * @param ShippingLabelGenerator $shippingLabelGenerator
     */
    public function __construct(
        OrderShipmentDataGeneratorService $orderShipmentDataGeneratorService,
        PluginInfo $pluginInfo,
        Util $util,
        ShippingLabelGenerator $shippingLabelGenerator
    ) {
        $this->orderShipmentDataGeneratorService = $orderShipmentDataGeneratorService;
        $this->pluginInfo = $pluginInfo;
        $this->util = $util;
        $this->shippingLabelGenerator = $shippingLabelGenerator;
    }

    /**
     * @inheritdoc
     */
    public function createReturnLabel(
        $orderId,
        array $receiverAddress,
        $weightInKg,
        array $configuration = null
    ) {
        $shipment = $this->shippingLabelGenerator->createReturnLabel(
            $orderId,
            $weightInKg,
            $receiverAddress,
            null, // packageDimensions,
            $configuration ?: [], // shippingSettings
            [] // extraSettings
        );

        $result = $this->orderShipmentDataGeneratorService->generateOrderShipmentData(
            $this->pluginInfo,
            $orderId,
            $shipment
        );
        $result['documentIdentifier'] = $this->util->getIdentifierFromLabelUrl($result['url']);

        if (!$orderId) {
            return $result;
        }

        /** @var Order $order */
        $order = Shopware()->Models()->find(Order::class, $orderId);
        $returnLabelTrackingCodes = $order->getAttribute()->getViisonReturnLabelTrackingId();
        $newReturnLabelTrackingCodes = explode(',', $returnLabelTrackingCodes);
        $newReturnLabelTrackingCodes[] = $result['trackingCode'];
        $newReturnLabelTrackingCodes = array_filter($newReturnLabelTrackingCodes, 'strlen');
        $newReturnLabelTrackingCodes = implode(',', $newReturnLabelTrackingCodes);
        $order->getAttribute()->setViisonReturnLabelTrackingId($newReturnLabelTrackingCodes);
        Shopware()->Models()->flush($order->getAttribute());

        return $result;
    }
}
