<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="content-type" content="text/html; utf-8">
        <title></title>
        <style type="text/css">

            @page {
                margin: 12mm;
            }

            body {
                font-family: 'Helvetica Neue', Arial, sans-serif;
                font-size: 11pt;
                line-height: 1.5;
            }

            h1 {
                margin-bottom: 5mm;
                padding-bottom: 5mm;
                border-bottom: 0.5pt solid #999999;
                font-size: 16pt;
                font-weight: normal;
            }

            h2 {
                margin: 15mm 0 2mm;
                font-size: 12pt;
                font-weight: bold;
                color: #000000;
            }

            .infobox {
                margin-bottom: 0.5cm;
            }

            table {
                border-collapse: collapse;
                border-spacing: 0px;
            }

            tr td {
                border-bottom: 0.5pt solid #CCCCCC;
            }

            tr.header td {
                padding-bottom: 3mm;
                border-bottom: 1pt solid #000000;
            }

            tr.total td {
                border-top: 1pt solid #000000;
                border-bottom: 1pt solid #000000;
                font-weight: bold;
            }

            .signature {
                padding-top: 2cm;
                text-align: center;
                float: left;
                width: 50%;
            }
        </style>
    </head>
    <body>
        <h1>{$dispatchServiceProviderName} Tagesabschluss für den Zeitraum: {if !$wholeDays}<br/>{/if}{* Insert line break so that the time specification does not break in the middle *}
        <strong>{if $fromDate != $toDate}{$fromDate} - {$toDate}{else}{$fromDate}{/if}</strong></h1>
        <div class="infobox">
            <div><strong>Erstellt am:</strong> {$creationTime}</div>
        </div>
        {if $shopName}
            <div><strong>Shop:</strong> {$shopName}</div>
        {/if}
        <table cellpadding="10" cellspacing="0" style="table-layout: fixed; width: 100%">
            <tr class="header">
                <td style="width:22%">Empfänger</td>
                <td style="width:20%" align="right">Versandzeitpunkt</td>
                <td style="width:25%" align="right">Sendungsnr.</td>
                <td style="width:5%" align="right">Versandprodukt</td>
                <td style="width:1%" align="right">Gewicht</td>
                <td style="width:35%" align="right">Adresse</td>
            </tr>
            {foreach $dailyClosingData as $row}
                <tr>
                    <td style="word-wrap: break-word">{$row.receiver}</td>
                    <td align="right">{$row.dateTime}</td>
                    <td align="right">{$row.trackingCode}</td>
                    <td align="right">{$row.product}</td>
                    <td align="right">{$row.weight|number_format:2:",":"."}</td>
                    <td style="word-wrap: break-word" align="right">{$row.address}</td>
                </tr>
            {/foreach}
            <tr class="total">
                <td width="30%" colspan="2">Gesamtgewicht / Anzahl Pakete</td>
                <td width="64%" align="right" colspan="3">{$totalWeight|number_format:2:",":"."}</td>
                <td width="6%" align="right">{$numberOfParcels}</td>
            </tr>
        </table>

        <div class="signature">
            ____________________________<br/>
            Unterschrift Absender
        </div>
        <div class="signature">
            ____________________________<br/>
            Unterschrift Abholer
        </div>
    </body>
</html>
