### Product logic

> The implementation of [SHIPMENTLOGIC.md](SHIPMENTLOGIC.md) needs to be done first.

**Plugin Info**

* Inside the `PluginInfo.php` file override the `getProductModelName()` method

```php
    ...
       /**
        * @Override from ShippingCommon
       */
       public function getProductModelName()
       {
           return 'Shopware\CustomModels\ViisonPROVIDER_NAME\Product\Product';
       }
    ...
```

> The following method is not declared as Abstract inside Shipping Common because of the Backwards compatibility of Shipping Common.

**Entities**

* Add `ViisonProviderName\Product` folder to the `Models` directory.
* Add `Product.php` & `Repository.php` files inside the Product directory.
* Define the namespaces to follow this schema:
 `namespace Shopware\CustomModels\ViisonProviderName\Product;`
* Include the respective file namespaces from Shipping Common (for `Product.php` the [Product class](Models/ViisonShippingCommon/Product/Product.php) from ShippingCommon) also add the Doctrine namespaces to `Product.php`

```php
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
```
* Add the `@ORM\Table` and `@ORM\Entity` tags on the top of the class declaration s inside `Product.php`

```php
/**
 * Extends Configuration model from ShippingCommon
 *
 * @ORM\Entity(repositoryClass="Shopware\CustomModels\ViisonProviderName\Product\Repository")
 * @ORM\Table(name="s_viison_PROVIDER_NAME_products")
 *
 */
class Product extends ViisonShippingCommonProduct {...}
```

> The @ORM\Table needs to point to the existing products table if the Shipping Provider has been already released.

* Implement the Shipping Provider missing product fields and generate the getters/setters for it.

> The fields should have the column names from the existing table if the Adapter has been already Released.

* Extend the [Repository class](Models/ViisonShippingCommon/Product/Repository.php) from Shipping Common in `Repository.php`.

> Some Shipping Providers are overriding the `Controllers/ViisonShippingCommonShipping.php` and `Controllers/ViisonShippingCommonOrder.php` methods.
> In that overrides the logic needs to be adjusted to use the Doctrine models.
