<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// @codingStandardsIgnoreStart

$pluginFileFinder = include __DIR__ . '/PluginFileFinder.php';

// Load both the legacy (ViisonPickwareConnector) and new (ViisonPickwareMobile) shipping provider interfaces
if (($interfacePath = $pluginFileFinder('Core/ViisonPickwareConnector/API/')) !== false) {
    // Load legacy interfaces provided by the ViisonPickwareConnector plugin
    include_once($interfacePath . 'ShippingDocument.php');
    include_once($interfacePath . 'ShippingLabelCreationResult.php');
    include_once($interfacePath . 'ShippingProduct.php');
    include_once($interfacePath . 'ShippingProvider.php');
} elseif (!interface_exists('ViisonPickwareConnector_API_ShippingProvider')) {
    // Legacy interfaces not available and not declared yet, hence declare them
    interface ViisonPickwareConnector_API_ShippingDocument
    {
    }
    interface ViisonPickwareConnector_API_ShippingLabelCreationResult
    {
    }
    interface ViisonPickwareConnector_API_ShippingProduct
    {
    }
    interface ViisonPickwareConnector_API_ShippingProvider
    {
    }
}
if (($interfacePath = $pluginFileFinder('Core/ViisonPickwareMobile/Interfaces/ShippingProvider/')) !== false) {
    // Load new interfaces provided by the ViisonPickwareMobile plugin
    include_once($interfacePath . 'ShippingDocument.php');
    if (file_exists($interfacePath . 'ShippingDocumentType.php')) {
        include_once($interfacePath . 'ShippingDocumentType.php');
    } elseif (!interface_exists('ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocumentType')) {
        interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocumentType
        {
        }
    }
    include_once($interfacePath . 'ShippingLabelCreationResult.php');
    include_once($interfacePath . 'ShippingProduct.php');
    include_once($interfacePath . 'ShippingProvider.php');
} elseif (!interface_exists('ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProvider')) {
    // New interfaces not available and not declared yet, hence declare them
    interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocument
    {
    }
    interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocumentType
    {
    }
    interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingLabelCreationResult
    {
    }
    interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProduct
    {
    }
    interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProvider
    {
    }
}

// @codingStandardsIgnoreEnd
