<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\CompatibilityCheck as AbstractCompatibilityCheck;
use Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint;

class CompatibilityCheck extends AbstractCompatibilityCheck
{

    public function getPluginCompatibilityConstraints()
    {
        // Check that shipping adapters are compatible with the JS loader
        return array(
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonIntraship',
                '2.0.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonUPS',
                '2.0.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonDPD',
                '2.0.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonGLS',
                '2.0.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonSwissPost',
                '2.0.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonAustrianPost',
                '2.0.0' // minimum version
            )
        );
    }
}
