<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\SubApplicationRegistration as AbstractSubApplicationRegistration;

class SubApplicationRegistration extends AbstractSubApplicationRegistration
{

    /**
     * @override
     * @return string
     */
    public function getPluginPath()
    {
        return __DIR__ . '/../';
    }

    /**
     * @override
     */
    public function getSubApplications()
    {
        return array(
            'ViisonShippingCommonConfig' => array(
                null,
                array(
                    'ViisonShippingCommonOrder'
                ),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonConfig'
            ),
            'ViisonShippingCommonDailyClosing' => array(
                null,
                array(),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonDailyClosing'
            ),
            'ViisonShippingCommonFreeFormLabels' => array(
                null,
                array(
                    'ViisonShippingCommonOrder'
                ),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonFreeFormLabels'
            ),
            'ViisonShippingCommonGridLabelPrinting' => array(
                null,
                array(),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonGridLabelPrinting'
            ),
            'ViisonShippingCommonIndexPopup' => array(
                null,
                array(),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonIndexPopup'
            ),
            'ViisonShippingCommonMail' => array(
                null,
                array(
                    'ViisonCommonMailComposer'
                ),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonMail'
            ),
            'ViisonShippingCommonOrder' => array(
                'Order',
                array(
                    'ViisonCommonMailComposer'
                ),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonOrder'
            ),
            'ViisonShippingCommonShipping' => array(
                'Shipping',
                array(
                    'ViisonCommonMailComposer'
                ),
                array(),
                'Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonShipping'
            ),
        );
    }
}
