<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\ViewLoading as BaseViewLoading;
use \Shopware_Components_Plugin_Bootstrap as PluginBootstrap;

class ViewLoading extends BaseViewLoading
{
    /**
     * @param PluginBootstrap $pluginBootstrap
     */
    public function __construct(PluginBootstrap $pluginBootstrap)
    {
        parent::__construct($pluginBootstrap, 'ViisonShippingCommon');
    }

    /**
     * Overrides the default implementation to return the path to this library's root path.
     *
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getPluginPath()
     */
    public function getPluginPath()
    {
        return __DIR__ . '/../';
    }
}
