// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The dispatch service provider configuration window.
 */

//{namespace name="backend/viison_shipping_common_config/config"}
Ext.define('Shopware.apps.ViisonShippingCommonConfig.view.Window', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Enlight.app.Window',

    xtype: 'viison-shipping-common-config-window',

    autoScroll: true,

    snippets: {
        items: {
            'resetButtonText': '{s name="window/reset_text"}{/s}',
            'saveButtonText': '{s name="window/save_text"}{/s}'
        },
        'loadMaskMessage': '{s name="window/loadMask"}{/s}'
    },

    /**
     * The default initializer, which adds the form fields to this form panel.
     */
    initComponent: function(data) {
        // Prepare additional data send to the panel
        var dataObject = this.addAdditionalPanelData();
        Ext.apply(dataObject, this.additionalData || {});
        this.dataObject = dataObject;

        this.items = [];

        this.buttons = this.getButtons();

        this.loadMask = new Ext.LoadMask(this, {
            msg: this.snippets.loadMaskMessage
        });
        this.loadMask.hide();

        this.callParent(arguments);
    },

    /**
     * Add additional data to panel
     *
     * Note: This is a placeholder for the adapters so they can easily override this
     *
     * @returns object
     */
    addAdditionalPanelData: function() {
        return { };
    },

    addPanel: function () {
        this.configPanel = Ext.create(this.panelClass, this.dataObject);
        this.add(this.configPanel);
    },

    /**
     * @return array
     */
    getButtons: function() {
        return [{
            xtype: 'button',
            text: this.snippets.items.resetButtonText,
            cls: 'secondary',
            action: 'reset',
            listeners: {
                click: function () {
                    this.fireEvent('clickResetButton', this.configPanel);
                },
                scope: this,
            },
        },{
            xtype: 'button',
            text: this.snippets.items.saveButtonText,
            cls: 'primary',
            tooltip: '{s name="window/save_tooltip"}{/s}',
            action: 'save',
            listeners: {
                click: function () {
                    this.fireEvent('clickSaveButton', this.configPanel);
                },
                scope: this,
            },
        }];
    }

});
