// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A free form labels specific extension to the label confirm panel.
 */
//{namespace name="backend/viison_shipping_common_free_form_labels/label_confirm"}
Ext.define('Shopware.apps.ViisonShippingCommonFreeFormLabels.view.LabelConfirm', {

    freeFormLabelsSnippets: {
        exportDocumentInformation: {
            title: '{s name="label_confirm/export_document_information/title"}{/s}',
            labels: {
                itemName: '{s name="label_confirm/export_document_information/labels/item_name"}{/s}'
            }
        }
    },

    /**
     * Returns additional containers to be added to the items of the label confirm panel.
     *
     * @return A list of containers.
     */
    createExtraContainers: function() {
        return [
            this.createExportDocumentInformation()
        ];
    },

    /**
     * Returns all plugin-specific extra key value pairs that should be sent to the PHP controller when
     * creating a label.
     *
     * @return An object containing the extra key value pairs
     */
    getExtraSettings: function() {
        return this.exportDocumentInformation.getForm().getValues();
    },

    /**
     * Create the form panel containing the export document information.
     *
     * @return The created panel.
     */
    createExportDocumentInformation: function() {
        var me = this;

        me.exportDocumentInformation = Ext.create('Ext.form.Panel', {
            cls: 'confirm-panel-label-type',
            title: me.freeFormLabelsSnippets.exportDocumentInformation.title,
            bodyPadding: 5,
            margin: '5 0 0 0',
            layout: 'anchor',
            defaults: {
                anchor: '100%'
            },
            items: me.createExportDocumentInformationFormRows(105, 10)
        });

        return me.exportDocumentInformation;
    },

    /**
     * Creates all label type form rows containing a label and at least one input field.
     *
     * @param labelWidth The width for all labels in this panel.
     * @param columnPadding
     * @return An array containing the created rows.
     */
    createExportDocumentInformationFormRows: function(labelWidth, columnPadding) {
        var me = this;

        return [
            me.createFormRow({
                padding: columnPadding,
                label: {
                    width: labelWidth,
                    text: me.freeFormLabelsSnippets.exportDocumentInformation.labels.itemName,
                    labelStyle: 'margin-top: 0px'
                },
                items: [
                    {
                        xtype: 'textfield',
                        name: 'itemName',
                        flex: 1,
                        allowBlank: false
                    }
                ]
            })
        ];
    },

    /**
     * Update the visibility of the export document information group.
     *
     * @param field The field firing the 'change' event.
     * @param newValue The new value of the changed field.
     */
    createExportDocumentChanged: function(field, newValue) {
        this.updateExtraContainersVisibility();
    },

    updateExtraContainersVisibility: function() {
        var me = this;
        if (me.isReturn) {
            return;
        }
        var cashOnDeliveryChecked = me.cashOnDelivery.getValue();
        var createExportDocumentChecked = me.createExportDocument.getValue();
        var exportDocumentVisibility = createExportDocumentChecked;
        var orderAmountVisibility = cashOnDeliveryChecked || createExportDocumentChecked;
        me.orderAmountInformation.setVisible(orderAmountVisibility);
        me.exportDocumentInformation.setVisible(exportDocumentVisibility);
        if (orderAmountVisibility) {
            me.orderAmountInformation.enable();
        } else {
            me.orderAmountInformation.disable();
        }
        if (exportDocumentVisibility) {
            me.exportDocumentInformation.enable();
        } else {
            me.exportDocumentInformation.disable();
        }
        if (me.rendered) {
            // Re-center window to make sure that the buttons are inside the visible area
            me.up('order-viison-shipping-common-label-confirm-window').center();
        }
    }

});
