// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling all batch label creation status information objects.
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.store.BatchLabelStatus', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * Define the used model for this store.
     */
    model: 'Shopware.apps.ViisonShippingCommonOrder.model.BatchLabelStatus',

    /**
     * Disable auto loading.
     */
    autoLoad: false,

    /**
     * Sort the list first by its ascending success status, meaning that failed orders will be displayed first.
     * Finally all orders with the same status will be ordered by its descending order number.
     */
    sorters: [
        {
            property: 'success',
            direction: 'ASC'
        }, {
            property: 'orderNumber',
            direction: 'DESC'
        }
    ]

});
