// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling Config Data for Order flow
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.store.OrderConfigData', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * The id used to find the store in the application.
     */
    storeId: 'viison-shipping-common-order-config-store',

    /**
     * Model for Order Config Store
     */
    model: 'Shopware.apps.ViisonShippingCommonOrder.model.OrderConfigData',

    /**
     * URL for Action to fill the store
     *
     * NOTE: All Adapters need to override this property with their OrderController
     *       because only than we can accsess the PluginInfo Class of the Adapter
     *       otherwise PluginInfo will be null (Validation is implemented for this case)
     */
    getCommonConfigData: '{url controller="ViisonShippingCommonOrder" action="getOrderConfigData"}',

    /**
     * Disable auto loading.
     */
    autoLoad: false,

    /**
     * Configure the data communication.
     *
     * NOTE: Because we are using a URL property 'getCommonConfigData'
     *       we need to create the store in the constructor and
     *       not with proxy property object of Ect.data.Store
     */
    constructor: function() {
        this.setProxy({
            type: 'ajax',
            url: this.getCommonConfigData,
            reader: {
                type: 'json',
                root: 'data'
            }
        });

        this.callParent(arguments);
    }
});
