// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling all ShippingLabel objects.
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.store.ShippingLabel', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * Set store page size to allow grid paging.
     */
    pageSize: 10,

    /**
     * Disable auto loading.
     */
    autoLoad: false,

    remoteSort: true,

    sorters: [
        {
            property: 'created',
            direction: 'DESC'
        }
    ],


    constructor: function() {
        // configure the data communication
        this.setProxy({
            type: 'ajax',
            url: this.getAllLabelsURL,
            reader: {
                type: 'json',
                root: 'data',
                totalProperty: 'total'
            }
        });

        this.callParent(arguments);
    }

});
