// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The window containing a single LabelConfirm panel.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.view.detail.LabelConfirmWindow', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Enlight.app.Window',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-shipping-common-label-confirm-window',

    /**
     * An optional extra CSS class that will be added to this component's Element.
     */
    cls: Ext.baseCSSPrefix + 'order-viison-shipping-common-label-confirm-window',

    /**
     * Define the window width.
     */
    width: 550,

    /**
     * Display no footer button for the detail window
     */
    footerButton: false,

    /**
     * Hide minimize button.
     */
    minimizable: false,

    /**
     * Hide maximize button.
     */
    maximizable: false,

    /**
     * Fix window at its initial position on the screen.
     */
    draggable: true,

    /**
     * Make the window modal.
     */
    modal: true,

    /**
     * The unique id for this object to use for state management purposes.
     */
    stateId: 'shopware-order-viison-shipping-common-label-confirm-window',

    /**
     * States if this is a return label confirm window
     */
    isReturn: false,

    /**
     * Set layout for this component to hbox.
     */
    layout: {
        align: 'stretch',
        type: 'hbox'
    },

    /**
     * Contains all snippets for the component.
     */
    snippets: {
        forwardLabelTitle: '{s name="label_confirm_window/forward_label_title"}{/s}',
        returnLabelTitle: '{s name="label_confirm_window/return_label_title"}{/s}',
        loadMaskMessage: '{s name="label_confirm_window/loadMask"}{/s}'
    },

    constructor: function() {
        var me = this;

        this.callParent(arguments);

        // Determine the window height automatically from its contents
        me.height = undefined;
    },

    /**
     * The main initializer adding view components.
     */
    initComponent: function() {
        var me = this;

        me.title = me.isReturn ? me.snippets.returnLabelTitle : me.snippets.forwardLabelTitle;

        me.items = [
            me.createDataPanel()
        ];

        me.loadMask = new Ext.LoadMask(me, {
            msg: me.snippets.loadMaskMessage
        });
        me.loadMask.hide();

        me.callParent(arguments);
    },

    /**
     * Create the main Panel containing all view components.
     *
     * @return The created view panel.
     */
    createDataPanel: function() {
        var me = this;

        me.dataPanel =  Ext.create(me.labelConfirmPanelClass, {
            record: me.record,
            store: me.store,
            maxNumberOfLabels: me.maxNumberOfLabels,
            dispatchServiceProviderTab: me.dispatchServiceProviderTab,
            productStore: me.productStore,
            countriesStore: me.subApp.getController('Main').countriesStore,
            isReturn: me.isReturn,
            orderConfigData: me.orderConfigData
        });

        return me.dataPanel;
    }

});
