// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The window containing a single Mail panel.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.view.detail.MailWindow', {

    /**
     * Extend from the CommonMail window
     */
    extend: 'Shopware.apps.ViisonCommonMailComposer.view.Window',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-shipping-common-mail-window',

    /**
     * Create the main Panel containing all view components.
     *
     * NOTE: the tracking code has been replaced with labelId
     *
     * @return The created view panel.
     */
    createPanel: function() {
        return Ext.create('Shopware.apps.ViisonShippingCommonOrder.view.detail.Mail', {
            mail: this.mail,
            labelId: this.labelId,
            cls: this.cls
        });
    }

});
