// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * This implementation of the order backend details window adds a additional
 * dispatch service provider tab to the end of the tab panel.
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.view.detail.Window', {

    /**
     * Override the default order details window or at least parts of it.
     */
    override: 'Shopware.apps.Order.view.detail.Window',

    /**
     * Register a plugin specific tab to be added to the window.
     *
     * @param dispatchServiceProviderTab object Should provide dispatchServiceProviderTabClass and shippingLabelStoreClass to be used for the tab.
     */
    addDispatchServiceProviderTab: function(dispatchServiceProviderTab) {
        var me = this;
        me.dispatchServiceProviderTabs = me.dispatchServiceProviderTabs || [];
        me.dispatchServiceProviderTabs.push(dispatchServiceProviderTab);
    },

    /**
     * By overriding the default 'createTabPanel' method, an additional dispatch service provider tab
     * is added to the order details tab bar.
     *
     * @return An array containing all tabs of the order detail view.
     */
    createTabPanel: function() {
        var me = this;

        // Create the main tab panel
        var tabPanel = this.callParent(arguments);

        Ext.each(me.dispatchServiceProviderTabs, function(dispatchServiceProviderTab) {
            // Add a new dispatchs service provider tab to the panel
            tabPanel.add(Ext.create(dispatchServiceProviderTab.dispatchServiceProviderPanelClass, {
                record: me.record,
                shippingLabelStoreClass: dispatchServiceProviderTab.shippingLabelStoreClass,
                subApp: me.subApp
            }));
        });

        return tabPanel;
    }

});
