<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

if (!class_exists('ViisonShippingCommon_Classes_ShippingProvider')) {
    // Inlcude the legacy proxy classes
    require_once(__DIR__ . '/Classes/DailyClosingGenerator.php');
    require_once(__DIR__ . '/Classes/EventManagerCompat.php');
    require_once(__DIR__ . '/Classes/GridDocumentRenderer.php');
    require_once(__DIR__ . '/Classes/LocalDailyClosingGenerator.php');
    require_once(__DIR__ . '/Classes/PluginInfo.php');
    require_once(__DIR__ . '/Classes/ShippingDocument.php');
    require_once(__DIR__ . '/Classes/ShippingLabelCreationResult.php');
    require_once(__DIR__ . '/Classes/ShippingLabelGenerator.php');
    require_once(__DIR__ . '/Classes/ShippingProduct.php');
    require_once(__DIR__ . '/Classes/ShippingProvider.php');
    require_once(__DIR__ . '/Classes/ShippingUtil.php');
    require_once(__DIR__ . '/Components/ViisonShippingCommonDispatchData.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonConfig.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonDailyClosing.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonFreeFormLabels.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonGridLabelPrinting.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonOrder.php');
    require_once(__DIR__ . '/Controllers/Backend/ViisonShippingCommonShipping.php');
    require_once(__DIR__ . '/Subscriber/CompatibilityCheck.php');
    require_once(__DIR__ . '/Subscriber/ShippingCommon.php');
    require_once(__DIR__ . '/Subscriber/SubApplicationRegistration.php');
    require_once(__DIR__ . '/Util.php');

    // Register an anonymous subscriber on the legacy ViisonShippingCommon version negotiation
    // to block all outdated shipping plugins from loading their ViisonShippingCommon
    Shopware()->Events()->registerListener(new \Enlight_Event_Handler_Default(
        'Shopware_ViisonShippingCommon_GetNewestVersion',
        function (\Enlight_Event_EventArgs $args) {
            $version = $args->getReturn();
            $myVersion = include(__DIR__ . '/../Version.php');
            // Check if my version is newer
            if ($version === null || version_compare($myVersion, $version, '>')) {
                $version = $myVersion;
            }

            return $version;
        }
    ));

    // Notify all plugins that use legacy loading
    Shopware()->Events()->notify('Shopware_ViisonShippingCommon_Loaded');
}
