<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class DHLExpressException extends \Exception implements LocalizableThrowable
{
    /**
     * @var array The key value of the array represents the error code returned from DHL Express
     * and the value is the error message.
     */
    private $errors;

    /**
     * @param array $errors
     */
    public function __construct(array $errors)
    {
        $this->errors = $errors;

        $message = "Label creation failed. The following API errors have occurred:\n";
        foreach ($errors as $errorCode => $errorMessage) {
            $message .= $errorCode . ': ' . $errorMessage . "\n";
        }

        parent::__construct($message);
    }

    /**
     * @inheritdoc
     */
    public function getLocalizedMessage(\Enlight_Components_Snippet_Manager $snippetManager)
    {
        $snippetNamespace = $snippetManager->getNamespace('exceptions/viison_dhl_express');
        $message = $snippetNamespace->get('webserviceRequestFailed') . "\n";
        foreach ($this->errors as $errorCode => $errorMessage) {
            $fallbackMessage = $errorCode . ': ' . $errorMessage;
            $message .= $snippetNamespace->get('error/code/' . $errorCode, $fallbackMessage) . "\n";
        }

        return $message;
    }
}
