<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes\DHLPortalConfigScraper;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

abstract class AbstractDhlConfigScraperException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     * @param Exception|null $previousException
     */
    public function __construct($message, $snippetName, array $snippetArguments = [], Exception $previousException = null)
    {
        $this->snippetName = $snippetName;
        $this->snippetArguments = $snippetArguments;
        $this->snippetNamespace = 'exceptions/viison_dhl/dhl_config_scraper';

        parent::__construct($message, 0, $previousException);
    }
}
