<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes\DHLPortalConfigScraper;

use Exception;

class DhlConfigScraperCommunicationException extends AbstractDhlConfigScraperException
{
    /**
     * @param Exception|null $previousException
     * @return DhlConfigScraperCommunicationException
     */
    public static function unexpectedError(Exception $previousException)
    {
        $message = sprintf('There occurred an unexpected error: %s', $previousException->getMessage());

        return new self($message, 'communication/unexpectedError', [], $previousException);
    }

    /**
     * @return DhlConfigScraperCommunicationException
     */
    public static function loopTokenNotFound()
    {
        return new self('No _afrLoop token found in DHL server response.', 'communication/loopTokenNotFound');
    }
}
