<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes\DHLPortalConfigScraper;

class DhlConfigScraperInvalidCredentialsException extends AbstractDhlConfigScraperException
{
    /**
     * @return DhlConfigScraperInvalidCredentialsException
     */
    public static function userNameOrPasswordMissing()
    {
        return new self('The user name and the password cannot be empty.', 'invalidCredentials/userNameOrPasswordMissing');
    }

    /**
     * @return DhlConfigScraperInvalidCredentialsException
     */
    public static function loginFailed()
    {
        return new self('The login to DHL GKP failed due to invalid credentials.', 'invalidCredentials/loginFailed');
    }
}
