<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes\DHLPortalConfigScraper;

class DhlContractPosition
{
    /**
     * @var array
     */
    private $attendanceNumbers;

    /**
     * @var string
     */
    private $productName;

    /**
     * @var string
     */
    private $productCode;

    /**
     * @var string
     */
    private $productProcessCode;

    /**
     * @param array $attendanceNumbers
     * @param string $productName
     * @param string $productCode
     * @param string $productProcessCode
     */
    public function __construct(array $attendanceNumbers, $productName, $productCode, $productProcessCode)
    {
        $this->attendanceNumbers = $attendanceNumbers;
        $this->productName = $productName;
        $this->productCode = $productCode;
        $this->productProcessCode = $productProcessCode;
    }

    /**
     * @return array
     */
    public function getAttendanceNumbers()
    {
        return $this->attendanceNumbers;
    }

    /**
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }

    /**
     * @return string
     */
    public function getProductCode()
    {
        return $this->productCode;
    }

    /**
     * @return string
     */
    public function getProductProcessCode()
    {
        return $this->productProcessCode;
    }
}
