<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes\DhlExpressServiceOptions;

use Shopware\Plugins\ViisonDHL\Classes\SoapRequestBodyMutator;

class DhlExpressInsuredServiceOption implements SoapRequestBodyMutator
{
    /**
     * The insured value needs to be float, otherwise the DHL Express service is throwing a exception.
     *
     * @var float
     */
    private $insuredValue;

    /**
     * The currency should be in currency-code format like: EUR, USD ...
     * @var string
     */
    private $insuredCurrency;

    /**
     * @param float $insuredValue
     * @param string $insuredCurrency
     */
    public function __construct($insuredValue, $insuredCurrency)
    {
        $this->insuredValue = $insuredValue;
        $this->insuredCurrency = $insuredCurrency;
    }

    /**
     * @inheritdoc
     */
    public function mutate(array $requestBody)
    {
        $requestBody['RequestedShipment']['ShipmentInfo']['SpecialServices'][] = [
            'ServiceType' => 'II',
            'ServiceValue' => $this->insuredValue,
            'CurrencyCode' => $this->insuredCurrency,
        ];

        return $requestBody;
    }
}
