<?php
namespace Shopware\Plugins\ViisonDHL\Classes\DhlServiceOptions;

use Shopware\Plugins\ViisonDHL\Classes\SoapRequestBodyMutator;

class NoNeighbourDeliveryServiceOption implements SoapRequestBodyMutator
{
    /**
     * @var bool
     */
    private $noNeighbourDelivery = false;

    /**
     * @param array $requestBody
     * @return array
     */
    public function mutate(array $requestBody)
    {
        if ($this->noNeighbourDelivery) {
            $requestBody['ShipmentOrder']['Shipment']['ShipmentDetails']['Service']['NoNeighbourDelivery'] = [
                'active' => 1,
            ];
        }

        return $requestBody;
    }

    /**
     * @param array $extraSettings
     * @return NoNeighbourDeliveryServiceOption
     */
    public static function createFromExtraSettings(array $extraSettings)
    {
        $noNeighbourDeliveryServiceOption = new self();

        $noNeighbourDeliveryKeyExists = !empty($extraSettings['noNeighbourDelivery']) && array_key_exists('noNeighbourDelivery', $extraSettings);
        if ($noNeighbourDeliveryKeyExists && $extraSettings['noNeighbourDelivery']) {
            $noNeighbourDeliveryServiceOption->noNeighbourDelivery = true;
        }

        return $noNeighbourDeliveryServiceOption;
    }
}
