<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

use Shopware\Plugins\ViisonDHL\Classes\SoapRequest;

/**
 * Class DoManifestRequest
 *
 * This class represents an DHL SOAP API call to the GetManifest method.
 * Therefore it overrides the constructor expecting a from and to date for the
 * date range, which will be added to the request.
 *
 * @package Shopware\Plugins\ViisonDHL\Classes
 */
class DoManifestRequest implements SoapRequest
{

    /**
     * The list of tracking codes which should be manifested.
     */
    private $trackingCodes;

    /**
     * The main constructor creating all necessary parts for the request body.
     *
     * @param string[] $trackingCodes The list of tracking codes which should be manifested.
     */
    public function __construct($trackingCodes)
    {
        $this->trackingCodes = $trackingCodes;
    }

    /**
     * Creates the main request body.
     *
     * @param array $version The DHL API version which should be used.
     * @return array The request body.
     */
    public function getBody($version)
    {
        $body = [
            'Version' => $version,
            'shipmentNumber' => $this->trackingCodes,
        ];

        return $body;
    }
}
