<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

use Shopware\Plugins\ViisonDHL\Classes\SoapRequest;

/**
 * Class GetExportDocRequest
 *
 * This class represents an DHL SOAP API call to the GetExportDoc method.
 * Therefor it overrides the constructor expecting the tracking code of the shipment
 * whose export document PDF URL should be fetched.
 *
 * @package Shopware\Plugins\ViisonDHL\Classes
 */
class GetExportDocRequest implements SoapRequest
{

    /**
     * The shipment number (tracking code) of the order to get.
     */
    private $shipmentNumber;

    /**
     * The main constructor creating all necessary parts for the request body.
     *
     * @param string $trackingCode The tracking code used to find the order and fetch its export document URL.
     */
    public function __construct($trackingCode)
    {
        $this->shipmentNumber = $trackingCode;
    }

    /**
     * Creates the main request body containing the shipment number.
     *
     * @param array $version The DHL API version which should be used.
     * @return array The request body containing the shipment number.
     */
    public function getBody($version)
    {
        $body = [
            'Version' => $version,
            'shipmentNumber' => $this->shipmentNumber,
        ];

        return $body;
    }
}
