<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

use Shopware\Plugins\ViisonDHL\Classes\SoapRequest;

/**
 * Class GetManifestRequest
 *
 * This class represents an DHL SOAP API call to the GetManifest method.
 * Therefore it overrides the constructor expecting a from and to date for the
 * date range, which will be added to the request.
 *
 * @package Shopware\Plugins\ViisonDHL\Classes
 */
class GetManifestRequest implements SoapRequest
{

    /**
     * The date range, from which all created shipment labels will be included in the manifest.
     */
    private $manifestDate;

    /**
     * The main constructor creating all necessary parts for the request body.
     *
     * @param string $date The date for which the manifest should be requested.
     */
    public function __construct($date)
    {
        $this->manifestDate = $date;
    }

    /**
     * Creates the main request body.
     *
     * @param array $version The DHL API version which should be used.
     * @return array The request body.
     */
    public function getBody($version)
    {
        $body = [
            'Version' => $version,
            'manifestDate' => $this->manifestDate,
        ];

        return $body;
    }
}
