<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

class NonCodableAddressDHLException extends DHLException
{
    /**
     * DHL error codes. We only need error codes for errors that require special treatment in the frontend.
     *
     * Unfortunately, the error is catched in ShippingCommon::createLabel(), and because of that we can't
     * catch the NonCodableAddressDHLException explicitly and set the error code for the front end.
     */
    const ERROR_CODE = 1;

    /**
     * @return self
     */
    public static function missingStreetNumberForCodableAddress()
    {
        return new self(
            'A street number should be assigned for codable addresses.',
            self::ERROR_CODE,
            'missingStreetNumber'
        );
    }

    /**
     * @return self
     */
    public static function packingStationNonCodable()
    {
        return new self(
            'The specified Packstation number is not codable. Please check whether the Packstation number is correct.',
            self::ERROR_CODE,
            'packingStationNonCodable'
        );
    }

    /**
     * @return self
     */
    public static function addressNonCodeable()
    {
        return new self(
            'The given address is not codeable. Please check if the address is valid.',
            self::ERROR_CODE,
            'addressNonCodeable'
        );
    }
}
