<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Classes;

use SoapHeader;
use SoapVar;
use stdClass;

// Based on https://stackoverflow.com/a/6677930
class WsseAuthHeader extends SoapHeader
{
    private $wssNamespace = 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd';

    public function __construct($username, $password, $namespace = null)
    {
        if ($namespace) {
            $this->wssNamespace = $namespace;
        }

        $auth = new stdClass();
        $auth->Username = new SoapVar($username, XSD_STRING, null, $this->wssNamespace, null, $this->wssNamespace);
        $auth->Password = new SoapVar($password, XSD_STRING, null, $this->wssNamespace, null, $this->wssNamespace);

        $usernameToken = new stdClass();
        $usernameToken->UsernameToken = new SoapVar(
            $auth,
            SOAP_ENC_OBJECT,
            null,
            $this->wssNamespace,
            'UsernameToken',
            $this->wssNamespace
        );

        $security = new SoapVar(
            new SoapVar($usernameToken, SOAP_ENC_OBJECT, null, $this->wssNamespace, 'UsernameToken', $this->wssNamespace),
            SOAP_ENC_OBJECT,
            null,
            $this->wssNamespace,
            'Security',
            $this->wssNamespace
        );

        parent::__construct($this->wssNamespace, 'Security', $security, true);
    }
}
