<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Components;

use Shopware\Plugins\ViisonShippingCommon\Components\Logger\AbstractHttpRequestLogger;

class DhlHttpLogger extends AbstractHttpRequestLogger
{
    /**
     * @inheritDoc
     */
    public function filterSensitiveDataFromRequestHeader($headerKey, $headerValue)
    {
        if (in_array($headerKey, ['Authorization', 'DPDHL-User-Authentication-Token'])) {
            return '*HIDDEN*';
        }

        return $headerValue;
    }

    /**
     * @inheritDoc
     */
    public function filterSensitiveDataFromRequestBody($body)
    {
        return $body;
    }
}
