<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Components;

use Shopware\Plugins\ViisonShippingCommon\Components\Logger\AbstractSoapLogger;

class DhlSoapLogger extends AbstractSoapLogger
{
    /**
     * @inheritDoc
     */
    public function filterSensitiveHeaderData($headerString)
    {
        $headers = explode("\n", $headerString);
        foreach ($headers as &$header) {
            if (mb_stripos($header, 'Authorization') !== false) {
                $header = 'Authorization: *HIDDEN*';
            }
        }

        return implode("\n", $headers);
    }

    /**
     * @inheritDoc
     */
    public function filterSensitiveBodyData($body)
    {
        try {
            $dom = new \DOMDocument();
            $dom->loadXML($body);

            $xpath = new \DOMXpath($dom);
            $xpath->registerNamespace('dhl', 'http://dhl.de/webservice/cisbase');
            $elements = $xpath->query('//dhl:Authentification/dhl:signature');
            /** @var \DOMNode $element */
            foreach ($elements as $element) {
                $element->textContent = '*HIDDEN*';
            }

            return $dom->saveXML();
        } catch (\Exception $e) {
            return 'Could not parse XML. XML is truncated for security reasons. You can enable sensitive logging to disable truncating.';
        }
    }
}
