<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class Article extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PostDispatchSecure_Backend_Article' => 'onSecurePostDispatchArticle',
        ];
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     */
    public function onSecurePostDispatchArticle(\Enlight_Event_EventArgs $args)
    {
        $view = $args->getSubject()->View();
        // Load view extensions
        if ($args->getRequest()->getActionName() === 'load') {
            $view->extendsTemplate('backend/article/viison_dhl/articledetails.js');
        }
    }
}
