<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers\Backend;

use Shopware\Plugins\ViisonShippingCommon\Classes\Subscribers\Index as ViisonShippingCommonIndexSubscriber;

class Index extends ViisonShippingCommonIndexSubscriber
{
    /**
     * @inheritdoc
     */
    protected function extendTemplates($view)
    {
        $view->extendsTemplate('backend/index/viison_dhl/header.tpl');
        $view->extendsTemplate('backend/index/viison_dhl/menu_manipulation.js');
    }

    /**
     * @inheritdoc
     */
    protected function setPluginIconPath($view, $plugin, $args)
    {
        $view->viisonDHLPluginIconURL = $this->getPluginIconPath($args, $plugin);
    }
}
