<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\CompatibilityCheck as AbstractCompatibilityCheckSubscriber;
use Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint;

class CompatibilityCheckSubscriber extends AbstractCompatibilityCheckSubscriber
{
    /**
     * @inheritdoc
     */
    public function getPluginCompatibilityConstraints()
    {
        $snippets = $this->getContainer()->get('snippets')->getNamespace(
            'backend/viison_dhl_util/compatibility_check'
        );

        return [
            // "Produkt Konfigurator für Sets / Bundles" causes items to appear twice on the export document because
            // of an extension of one of our functions.
            // More information here https://github.com/pickware/ShopwareDHLAdapter/issues/386
            new PluginCompatibilityConstraint(
                'Frontend',
                'SwkweSetBuy',
                '9999.9999.9999', // Mark as "incompatible"
                $snippets->get('SwkweSetBuy/message')
            ),
        ];
    }
}
