<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers\Components;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonCommon\Classes\Util\Document as DocumentUtil;
use Shopware\Plugins\ViisonDHL\Util;

class DocumentSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Components_Document::assignValues::after' => 'onAfterAssignValues',
        ];
    }

    /**
     * Is executed after the document template variables have been assigned to the view. Manipulation of template
     * variables is done here.
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onAfterAssignValues(\Enlight_Hook_HookArgs $args)
    {
        /** @var $document \Shopware_Components_Document */
        $documentComponent = $args->getSubject();
        $documentTypeId = DocumentUtil::getDocumentTypeId($documentComponent);

        if ($documentTypeId !== DocumentUtil::DOCUMENT_TYPE_ID_INVOICE) {
            return;
        }
        $orderId = DocumentUtil::getOrderId($documentComponent);
        if (!$orderId) {
            return;
        }
        $util = Util::instance();
        $dispatchMethodSettings = $util->getDispatchMethodLevelSettings($orderId);
        $frankatur = $dispatchMethodSettings['frankatur'];
        if (!$frankatur) {
            return;
        }
        $namespace = $this->get('snippets')->getNamespace('backend/viison_dhl_shipping/terms_of_trade');
        $frankaturDescription = $namespace->get($frankatur);

        $documentComponent->_view->assign('viisonFrankaturDescription', $frankaturDescription);
    }
}
