<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers;

use Monolog\Logger;
use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\LoggerFactory;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as ServicesSubscribers;
use Shopware\Plugins\ViisonDHL\Classes\PluginInfo;
use Shopware\Plugins\ViisonDHL\Components\DhlHttpLogger;
use Shopware\Plugins\ViisonDHL\Components\DhlSoapLogger;
use Shopware\Plugins\ViisonDHL\Components\ShippingDocumentTypeFactoryService;
use Shopware\Plugins\ViisonDHL\Components\ViisonDHLExportDocument;
use Shopware\Plugins\ViisonShippingCommon\Components\LabelPersister;

class Services extends ServicesSubscribers
{
    /**
     * @inheritdoc
     */
    public static function getServices()
    {
        return [
            'viison_dhl.export_document' => function (Container $container) {
                return new ViisonDHLExportDocument(
                    $container->get('models'),
                    $container->get('viison_shipping_common.currency_converter'),
                    $container->get('ViisonShippingCommonDispatchData')
                );
            },
            'viison_dhl.shipping_document_type_factory' => function (Container $container) {
                return new ShippingDocumentTypeFactoryService(
                    $container->get('viison_common.snippet_manager')
                );
            },
            'viison_dhl.logger' => function (Container $container) {
                // Make log level configurable via config.php:
                // 'viisonDHL' => [
                //     'logger' => [
                //         'level' => Logger::DEBUG,
                //     ],
                // ],
                $environment = $container->getParameter('kernel.environment');
                // The "shopware." prefix is added by Shopware
                if ($container->hasParameter('shopware.viisondhl.logger.level')) {
                    $logLevel = $container->getParameter('shopware.viisondhl.logger.level');
                } else {
                    $logLevel = ($environment === 'production') ? Logger::INFO : Logger::DEBUG;
                }
                $loggerFactory = new LoggerFactory($container);

                return $loggerFactory->createLikePluginLogger('dhl', $logLevel);
            },
            'viison_dhl.soap_logger' => function (Container $container) {
                $dhlSoapLogger = new DhlSoapLogger($container->get('viison_dhl.logger'));
                // Make log level configurable via config.php:
                // 'viisonDHL' => [
                //     'soapLogger' => [
                //         'sensitive' => true,
                //     ],
                // ],
                if ($container->hasParameter('shopware.viisondhl.soapLogger.sensitive')
                    && $container->getParameter('shopware.viisondhl.soapLogger.sensitive')
                ) {
                    $dhlSoapLogger->setLogSensitiveData(true);
                }

                return $dhlSoapLogger;
            },
            'viison_dhl.http_logger' => function (Container $container) {
                $dhlHttpLogger = new DhlHttpLogger($container->get('viison_dhl.logger'));
                // Make log level configurable via config.php:
                // 'viisonDHL' => [
                //     'httpLogger' => [
                //         'sensitive' => true,
                //     ],
                // ],
                if ($container->hasParameter('shopware.viisondhl.httpLogger.sensitive')
                    && $container->getParameter('shopware.viisondhl.httpLogger.sensitive')
                ) {
                    $dhlHttpLogger->setLogSensitiveData(true);
                }

                return $dhlHttpLogger;
            },
            'viison_dhl.label_persister' => function (Container $container) {
                return new LabelPersister(
                    $container->get('viison_common.document_file_storage_service'),
                    $container->get('db'),
                    (new PluginInfo())->getOrderTableName()
                );
            },
        ];
    }
}
