<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonDHL\Subscribers;

class SubApplicationRegistration extends \Shopware\Plugins\ViisonCommon\Classes\Subscribers\SubApplicationRegistration
{

    /**
     * @override
     */
    public function getSubApplications()
    {
        return [
            'ViisonDHLConfig' => [
                null,
                [
                    'ViisonDHLTermsOfTrade',
                    'ViisonShippingCommonConfig',
                    'ViisonShippingCommonFreeFormLabels',
                ],
            ],
            'ViisonDHLDailyClosing' => [
                null,
                [
                    'ViisonShippingCommonDailyClosing'
                ],
            ],
            'ViisonDHLFreeFormLabels' => [
                null,
                [
                    'ViisonDHLTermsOfTrade',
                    'ViisonDHLOrder',
                    'ViisonShippingCommonFreeFormLabels',
                ],
            ],
            'ViisonDHLOrder' => [
                'Order',
                [
                    'ViisonDHLTermsOfTrade',
                    'ViisonDHLShipping',
                    'ViisonShippingCommonOrder',
                ],
            ],
            'ViisonDHLShipping' => [
                'Shipping',
                [
                    'ViisonDHLTermsOfTrade',
                    'ViisonShippingCommonShipping',
                ],
            ],
            'ViisonDHLTermsOfTrade' => null,
        ];
    }
}
