// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{block name="backend/article/model/attribute/fields" append}
    // Add a field for storing custom values
    { name: 'viisonCustomsTariffNumber', type: 'string', defaultValue: '' },
    { name: 'viisonCountryOfOrigin', type: 'int', defaultValue: '' },
//{/block}

//{block name="backend/article/controller/main" append}
Ext.define('Shopware.apps.Article.controller.ViisonDHL.Main', {
    override: 'Shopware.apps.Article.controller.Main',

    init: function() {
        // Load the Country store so that the data of the country of origin attribute is displayed correctly in the article details
        Ext.data.StoreManager.lookup('base.Country').load();
        this.callParent(arguments);
    }
});
//{/block}
