// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {block name="backend/index/view/menu" append}
Ext.define('Shopware.apps.Index.view.ViisonDHL.MenuManipulation', {
    override: 'Shopware.apps.Index.view.Menu',

    /**
     * @Override
     */
    initComponent: function () {
        var result;

        this.on('menu-created', function (items) {
            Ext.each(items, function (category) {
                if (category && category.menu) {
                    Ext.each(category.menu.items.items, function (item) {
                        if (item.text === 'DHL' && String(item.handler).indexOf('\'Shopware.apps.Dhl\'') !== -1) {
                            item.text = 'DHL (Shopware)';
                        }
                    });
                }
            });
        });
        result = this.callParent(arguments);

        return result;
    },

});
// {/block}
