// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Since we do not want to slow down the loading process by synchronously loading the whole Config subapplication,
// we need to supply the ExtJS loader ourselves with the information how the Javascript code of it can be loaded
Ext.Loader.config.paths['Shopware.apps.Config'] = '{url controller="Config" action=load}';

/**
 * The configuration subapp.
 */
Ext.define('Shopware.apps.ViisonDHLConfig', {
    /**
     * Extends from the general sub-application controller, which handles
     * the sub-application behavior and the event bus.
     */
    extend: 'Enlight.app.SubApplication',

    /**
     * The name of the module.
     */
    name: 'Shopware.apps.ViisonDHLConfig',

    requires: [
        'Shopware.apps.Base.view.element.Boolean',
        'Shopware.apps.Base.view.element.Button',
        'Shopware.apps.Base.view.element.Text',
        'Shopware.apps.Base.view.element.TextArea',
    ],

    controllers: [
        'Main',
        'DHLScraper',
    ],

}, function () {
    delete Ext.Loader.config.paths['Shopware.apps.Config'];
});
